/*
Macro_scripts for UVW Unwrap

Version: 3dsmax 9



Revision History:
		
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		moved functions and dialog definition into the /stdplug/stdscripts/modifier_uvwunwrap_dialog.ms
	
	28th august 2006, Pierre-Felix Breton
		minor updates to actions

*/




macroScript OpenUnwrapUI
	category:~OPENUNWRAPUI_CATEGORY~           
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~OPENUNWRAPUI_TOOLTIP~		
	silentErrors:TRUE

	
(

  unwrapModPKW = modpanel.getcurrentobject()
  xPKW =  unwrapModPKW.GetWindowX()
  yPKW =  unwrapModPKW.GetWindowY()
  hPKW =  unwrapModPKW.GetWindowH()
  if (hPKW==0) then
  	(
	yPKW = -10
	)  
  pPKW = Point2 xPKW (yPKW+hPKW)
  CreateDialog UnwrapUIDialog pos:pPKW style:#(#style_border)
  
  if (hPKW==0) then
  	(
	unwrapUIdialog.height = 0 
	)
  
)


macroScript MoveUnwrapUI
	category:~MOVEUNWRAPUI_CATEGORY~           
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~MOVEUNWRAPUI_TOOLTIP~	
	silentErrors:TRUE

	
(
  unwrapModPKW = modpanel.getcurrentobject()
  xPKW = unwrapModPKW .GetWindowX()
  yPKW = unwrapModPKW .GetWindowY()
  hPKW = unwrapModPKW .GetWindowH()
  
  if (hPKW==0) then  
  	(
	yPKW = -10
	)

  pPKW = Point2 xPKW (yPKW+hPKW)
  SetDialogPos UnwrapUIDialog pPKW
    
  if (hPKW==0) then
  	(
	unwrapUIdialog.height = 0 
	)
   else
    (
	if 	(UnwrapUIDialog.dash_options.state==TRUE) then
		(
		if (unwrapUIdialog.height != 163 ) then
			unwrapUIdialog.height = 163  
		)
	else 
		(
		if (unwrapUIdialog.height != 78 ) then
			unwrapUIdialog.height = 78  
		)
	unwrapUIdialog.UpdateUI()
	)
)


macroScript CloseUnwrapUI
	category:~CLOSEUNWRAPUI_CATEGORY~           
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~CLOSEUNWRAPUI_TOOLTIP~
	silentErrors:TRUE

	
(
  DestroyDialog UnwrapUIDialog
)


-----------------------------------------------------

macroScript UVWUnwrap_Stitch
	category:~UVWUNWRAP_STITCH_CATEGORY~
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~UVWUNWRAP_STITCH_TOOLTIP~
	buttontext:~UVWUNWRAP_STITCH_BUTTONTEXT~
(
	on execute do actionMan.executeAction 2077580866 "40043"  -- All Commands: Stitch
	on altExecute type do actionMan.executeAction 2077580866 "40044"  -- All Commands: Stitch Dialog	
)

macroScript UVWUnwrap_Sketch
	category:~UVWUNWRAP_SKETCH_CATEGORY~
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~UVWUNWRAP_SKETCH_TOOLTIP~
	buttontext:~UVWUNWRAP_SKETCH_BUTTONTEXT~
(
	on execute do actionMan.executeAction 2077580866 "40114"  -- All Commands: Sketch
	on altExecute type do actionMan.executeAction 2077580866 "40112"  -- All Commands: Sketch Dialog
)

macroScript UVWUnwrap_Pack
	category:~UVWUNWRAP_PACK_CATEGORY~
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~UVWUNWRAP_PACK_TOOLTIP~
	buttontext:~UVWUNWRAP_PACK_BUTTONTEXT~
(
	on execute do actionMan.executeAction 2077580866 "40074"  -- All Commands: Pack
	on altExecute type do actionMan.executeAction 2077580866 "40075"  -- All Commands: Pack Dialog
)

macroScript UVWUnwrap_Relax
	category:~UVWUNWRAP_RELAX_CATEGORY~
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~UVWUNWRAP_RELAX_TOOLTIP~
	buttontext:~UVWUNWRAP_RELAX_BUTTONTEXT~
(
	on execute do actionMan.executeAction 2077580866 "40135"  -- All Commands: Relax
	on altExecute type do actionMan.executeAction 2077580866 "40136"  -- All Commands: Relax Dialog
)


